/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class StrictUtf8
extends Charset {
    public StrictUtf8() {
        super("StrictUtf8", new String[0]);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    @Override
    public boolean contains(Charset cs) {
        return "StrictUtf8".equals(cs.name());
    }

    private static boolean isSurrogate(char ch) {
        return ch >= '\ud800' && ch < '\ue000';
    }

    private static char highSurrogate(int codePoint) {
        return (char)((codePoint >>> 10) + 55232);
    }

    private static char lowSurrogate(int codePoint) {
        return (char)((codePoint & 0x3FF) + 56320);
    }

    private static void updatePositions(ByteBuffer src, int sp2, CharBuffer dst, int dp) {
        src.position(sp2 - src.arrayOffset());
        dst.position(dp - dst.arrayOffset());
    }

    private static void updatePositions(CharBuffer src, int sp2, ByteBuffer dst, int dp) {
        src.position(sp2 - src.arrayOffset());
        dst.position(dp - dst.arrayOffset());
    }

    public static class Parser {
        private CoderResult error = CoderResult.UNDERFLOW;

        public CoderResult error() {
            assert (this.error != null);
            return this.error;
        }

        public int parse(char c, CharBuffer in) {
            if (Character.isHighSurrogate(c)) {
                if (!in.hasRemaining()) {
                    this.error = CoderResult.UNDERFLOW;
                    return -1;
                }
                char d = in.get();
                if (Character.isLowSurrogate(d)) {
                    int character = Character.toCodePoint(c, d);
                    this.error = null;
                    return character;
                }
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            if (Character.isLowSurrogate(c)) {
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            char character = c;
            this.error = null;
            return character;
        }

        public int parse(char c, char[] ia, int ip, int il) {
            assert (ia[ip] == c);
            if (Character.isHighSurrogate(c)) {
                if (il - ip < 2) {
                    this.error = CoderResult.UNDERFLOW;
                    return -1;
                }
                char d = ia[ip + 1];
                if (Character.isLowSurrogate(d)) {
                    int character = Character.toCodePoint(c, d);
                    this.error = null;
                    return character;
                }
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            if (Character.isLowSurrogate(c)) {
                this.error = CoderResult.malformedForLength(1);
                return -1;
            }
            char character = c;
            this.error = null;
            return character;
        }
    }

    static final class Encoder
    extends CharsetEncoder {
        private Parser sgp;

        private Encoder(Charset cs) {
            super(cs, 1.1f, 3.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return !StrictUtf8.isSurrogate(c);
        }

        @Override
        public boolean isLegalReplacement(byte[] repl) {
            return repl.length == 1 && repl[0] >= 0 || super.isLegalReplacement(repl);
        }

        private static CoderResult overflow(CharBuffer src, int sp2, ByteBuffer dst, int dp) {
            StrictUtf8.updatePositions(src, sp2, dst, dp);
            return CoderResult.OVERFLOW;
        }

        private static CoderResult overflow(CharBuffer src, int mark2) {
            src.position(mark2);
            return CoderResult.OVERFLOW;
        }

        private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            char[] sa = src.array();
            int sp2 = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            int dlASCII = dp + Math.min(sl - sp2, dl - dp);
            while (dp < dlASCII && sa[sp2] < '\u0080') {
                da[dp++] = (byte)sa[sp2++];
            }
            while (sp2 < sl) {
                char c = sa[sp2];
                if (c < '\u0080') {
                    if (dp >= dl) {
                        return Encoder.overflow(src, sp2, dst, dp);
                    }
                    da[dp++] = (byte)c;
                } else if (c < '\u0800') {
                    if (dl - dp < 2) {
                        return Encoder.overflow(src, sp2, dst, dp);
                    }
                    da[dp++] = (byte)(0xC0 | c >> 6);
                    da[dp++] = (byte)(0x80 | c & 0x3F);
                } else if (StrictUtf8.isSurrogate(c)) {
                    int uc;
                    if (this.sgp == null) {
                        this.sgp = new Parser();
                    }
                    if ((uc = this.sgp.parse(c, sa, sp2, sl)) < 0) {
                        StrictUtf8.updatePositions(src, sp2, dst, dp);
                        return this.sgp.error();
                    }
                    if (dl - dp < 4) {
                        return Encoder.overflow(src, sp2, dst, dp);
                    }
                    da[dp++] = (byte)(0xF0 | uc >> 18);
                    da[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                    da[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                    da[dp++] = (byte)(0x80 | uc & 0x3F);
                    ++sp2;
                } else {
                    if (dl - dp < 3) {
                        return Encoder.overflow(src, sp2, dst, dp);
                    }
                    da[dp++] = (byte)(0xE0 | c >> 12);
                    da[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
                    da[dp++] = (byte)(0x80 | c & 0x3F);
                }
                ++sp2;
            }
            StrictUtf8.updatePositions(src, sp2, dst, dp);
            return CoderResult.UNDERFLOW;
        }

        private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark2 = src.position();
            while (src.hasRemaining()) {
                char c = src.get();
                if (c < '\u0080') {
                    if (!dst.hasRemaining()) {
                        return Encoder.overflow(src, mark2);
                    }
                    dst.put((byte)c);
                } else if (c < '\u0800') {
                    if (dst.remaining() < 2) {
                        return Encoder.overflow(src, mark2);
                    }
                    dst.put((byte)(0xC0 | c >> 6));
                    dst.put((byte)(0x80 | c & 0x3F));
                } else if (StrictUtf8.isSurrogate(c)) {
                    int uc;
                    if (this.sgp == null) {
                        this.sgp = new Parser();
                    }
                    if ((uc = this.sgp.parse(c, src)) < 0) {
                        src.position(mark2);
                        return this.sgp.error();
                    }
                    if (dst.remaining() < 4) {
                        return Encoder.overflow(src, mark2);
                    }
                    dst.put((byte)(0xF0 | uc >> 18));
                    dst.put((byte)(0x80 | uc >> 12 & 0x3F));
                    dst.put((byte)(0x80 | uc >> 6 & 0x3F));
                    dst.put((byte)(0x80 | uc & 0x3F));
                    ++mark2;
                } else {
                    if (dst.remaining() < 3) {
                        return Encoder.overflow(src, mark2);
                    }
                    dst.put((byte)(0xE0 | c >> 12));
                    dst.put((byte)(0x80 | c >> 6 & 0x3F));
                    dst.put((byte)(0x80 | c & 0x3F));
                }
                ++mark2;
            }
            src.position(mark2);
            return CoderResult.UNDERFLOW;
        }

        @Override
        protected final CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }

        public int encode(char[] sa, int sp2, int len, byte[] da) {
            int sl = sp2 + len;
            int dp = 0;
            int dlASCII = dp + Math.min(len, da.length);
            while (dp < dlASCII && sa[sp2] < '\u0080') {
                da[dp++] = (byte)sa[sp2++];
            }
            while (sp2 < sl) {
                char c;
                if ((c = sa[sp2++]) < '\u0080') {
                    da[dp++] = (byte)c;
                    continue;
                }
                if (c < '\u0800') {
                    da[dp++] = (byte)(0xC0 | c >> 6);
                    da[dp++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                if (StrictUtf8.isSurrogate(c)) {
                    int uc;
                    if (this.sgp == null) {
                        this.sgp = new Parser();
                    }
                    if ((uc = this.sgp.parse(c, sa, sp2 - 1, sl)) < 0) {
                        if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                            return -1;
                        }
                        da[dp++] = this.replacement()[0];
                        continue;
                    }
                    da[dp++] = (byte)(0xF0 | uc >> 18);
                    da[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                    da[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                    da[dp++] = (byte)(0x80 | uc & 0x3F);
                    ++sp2;
                    continue;
                }
                da[dp++] = (byte)(0xE0 | c >> 12);
                da[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
                da[dp++] = (byte)(0x80 | c & 0x3F);
            }
            return dp;
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        private Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        private static boolean isNotContinuation(int b) {
            return (b & 0xC0) != 128;
        }

        private static boolean isMalformed3(int b1, int b2, int b3) {
            return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128;
        }

        private static boolean isMalformed3_2(int b1, int b2) {
            return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128;
        }

        private static boolean isMalformed4(int b2, int b3, int b4) {
            return (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128;
        }

        private static boolean isMalformed4_2(int b1, int b2) {
            return b1 == 240 && b2 == 144 || (b2 & 0xC0) != 128;
        }

        private static boolean isMalformed4_3(int b3) {
            return (b3 & 0xC0) != 128;
        }

        private static CoderResult malformedN(ByteBuffer src, int nb) {
            switch (nb) {
                case 1: 
                case 2: {
                    return CoderResult.malformedForLength(1);
                }
                case 3: {
                    byte b1 = src.get();
                    byte b2 = src.get();
                    return CoderResult.malformedForLength(b1 == -32 && (b2 & 0xE0) == 128 || Decoder.isNotContinuation(b2) ? 1 : 2);
                }
                case 4: {
                    int b1 = src.get() & 0xFF;
                    int b2 = src.get() & 0xFF;
                    if (b1 > 244 || b1 == 240 && (b2 < 144 || b2 > 191) || b1 == 244 && (b2 & 0xF0) != 128 || Decoder.isNotContinuation(b2)) {
                        return CoderResult.malformedForLength(1);
                    }
                    if (Decoder.isNotContinuation(src.get())) {
                        return CoderResult.malformedForLength(2);
                    }
                    return CoderResult.malformedForLength(3);
                }
            }
            assert (false);
            return null;
        }

        private static CoderResult malformed(ByteBuffer src, int sp2, CharBuffer dst, int dp, int nb) {
            src.position(sp2 - src.arrayOffset());
            CoderResult cr = Decoder.malformedN(src, nb);
            StrictUtf8.updatePositions(src, sp2, dst, dp);
            return cr;
        }

        private static CoderResult malformed(ByteBuffer src, int mark2, int nb) {
            src.position(mark2);
            CoderResult cr = Decoder.malformedN(src, nb);
            src.position(mark2);
            return cr;
        }

        private static CoderResult malformedForLength(ByteBuffer src, int sp2, CharBuffer dst, int dp, int malformedNB) {
            StrictUtf8.updatePositions(src, sp2, dst, dp);
            return CoderResult.malformedForLength(malformedNB);
        }

        private static CoderResult malformedForLength(ByteBuffer src, int mark2, int malformedNB) {
            src.position(mark2);
            return CoderResult.malformedForLength(malformedNB);
        }

        private static CoderResult xflow(ByteBuffer src, int sp2, int sl, CharBuffer dst, int dp, int nb) {
            StrictUtf8.updatePositions(src, sp2, dst, dp);
            return nb == 0 || sl - sp2 < nb ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private static CoderResult xflow(Buffer src, int mark2, int nb) {
            src.position(mark2);
            return nb == 0 || src.remaining() < nb ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
        }

        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            byte[] sa = src.array();
            int sp2 = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            int dlASCII = dp + Math.min(sl - sp2, dl - dp);
            while (dp < dlASCII && sa[sp2] >= 0) {
                da[dp++] = (char)sa[sp2++];
            }
            while (sp2 < sl) {
                byte b3;
                byte b2;
                int srcRemaining;
                byte b1 = sa[sp2];
                if (b1 >= 0) {
                    if (dp >= dl) {
                        return Decoder.xflow(src, sp2, sl, dst, dp, 1);
                    }
                    da[dp++] = (char)b1;
                    ++sp2;
                    continue;
                }
                if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                    if (sl - sp2 < 2 || dp >= dl) {
                        return Decoder.xflow(src, sp2, sl, dst, dp, 2);
                    }
                    byte b22 = sa[sp2 + 1];
                    if (Decoder.isNotContinuation(b22)) {
                        return Decoder.malformedForLength(src, sp2, dst, dp, 1);
                    }
                    da[dp++] = (char)(b1 << 6 ^ b22 ^ 0xF80);
                    sp2 += 2;
                    continue;
                }
                if (b1 >> 4 == -2) {
                    srcRemaining = sl - sp2;
                    if (srcRemaining < 3 || dp >= dl) {
                        if (srcRemaining > 1 && Decoder.isMalformed3_2(b1, sa[sp2 + 1])) {
                            return Decoder.malformedForLength(src, sp2, dst, dp, 1);
                        }
                        return Decoder.xflow(src, sp2, sl, dst, dp, 3);
                    }
                    b2 = sa[sp2 + 1];
                    b3 = sa[sp2 + 2];
                    if (Decoder.isMalformed3(b1, b2, b3)) {
                        return Decoder.malformed(src, sp2, dst, dp, 3);
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    if (StrictUtf8.isSurrogate(c)) {
                        return Decoder.malformedForLength(src, sp2, dst, dp, 3);
                    }
                    da[dp++] = c;
                    sp2 += 3;
                    continue;
                }
                if (b1 >> 3 == -2) {
                    srcRemaining = sl - sp2;
                    if (srcRemaining < 4 || dl - dp < 2) {
                        if (srcRemaining > 1 && Decoder.isMalformed4_2(b1, sa[sp2 + 1])) {
                            return Decoder.malformedForLength(src, sp2, dst, dp, 1);
                        }
                        if (srcRemaining > 2 && Decoder.isMalformed4_3(sa[sp2 + 2])) {
                            return Decoder.malformedForLength(src, sp2, dst, dp, 2);
                        }
                        return Decoder.xflow(src, sp2, sl, dst, dp, 4);
                    }
                    b2 = sa[sp2 + 1];
                    b3 = sa[sp2 + 2];
                    byte b4 = sa[sp2 + 3];
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if (Decoder.isMalformed4(b2, b3, b4) || !Character.isSupplementaryCodePoint(uc)) {
                        return Decoder.malformed(src, sp2, dst, dp, 4);
                    }
                    da[dp++] = StrictUtf8.highSurrogate(uc);
                    da[dp++] = StrictUtf8.lowSurrogate(uc);
                    sp2 += 4;
                    continue;
                }
                return Decoder.malformed(src, sp2, dst, dp, 1);
            }
            return Decoder.xflow(src, sp2, sl, dst, dp, 0);
        }

        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark2 = src.position();
            int limit = src.limit();
            while (mark2 < limit) {
                byte b3;
                byte b2;
                int srcRemaining;
                byte b1 = src.get();
                if (b1 >= 0) {
                    if (dst.remaining() < 1) {
                        return Decoder.xflow(src, mark2, 1);
                    }
                    dst.put((char)b1);
                    ++mark2;
                    continue;
                }
                if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                    if (limit - mark2 < 2 || dst.remaining() < 1) {
                        return Decoder.xflow(src, mark2, 2);
                    }
                    byte b22 = src.get();
                    if (Decoder.isNotContinuation(b22)) {
                        return Decoder.malformedForLength(src, mark2, 1);
                    }
                    dst.put((char)(b1 << 6 ^ b22 ^ 0xF80));
                    mark2 += 2;
                    continue;
                }
                if (b1 >> 4 == -2) {
                    srcRemaining = limit - mark2;
                    if (srcRemaining < 3 || dst.remaining() < 1) {
                        if (srcRemaining > 1 && Decoder.isMalformed3_2(b1, src.get())) {
                            return Decoder.malformedForLength(src, mark2, 1);
                        }
                        return Decoder.xflow(src, mark2, 3);
                    }
                    b2 = src.get();
                    if (Decoder.isMalformed3(b1, b2, b3 = src.get())) {
                        return Decoder.malformed(src, mark2, 3);
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    if (StrictUtf8.isSurrogate(c)) {
                        return Decoder.malformedForLength(src, mark2, 3);
                    }
                    dst.put(c);
                    mark2 += 3;
                    continue;
                }
                if (b1 >> 3 == -2) {
                    srcRemaining = limit - mark2;
                    if (srcRemaining < 4 || dst.remaining() < 2) {
                        if (srcRemaining > 1 && Decoder.isMalformed4_2(b1, src.get())) {
                            return Decoder.malformedForLength(src, mark2, 1);
                        }
                        if (srcRemaining > 2 && Decoder.isMalformed4_3(src.get())) {
                            return Decoder.malformedForLength(src, mark2, 2);
                        }
                        return Decoder.xflow(src, mark2, 4);
                    }
                    b2 = src.get();
                    b3 = src.get();
                    byte b4 = src.get();
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if (Decoder.isMalformed4(b2, b3, b4) || !Character.isSupplementaryCodePoint(uc)) {
                        return Decoder.malformed(src, mark2, 4);
                    }
                    dst.put(StrictUtf8.highSurrogate(uc));
                    dst.put(StrictUtf8.lowSurrogate(uc));
                    mark2 += 4;
                    continue;
                }
                return Decoder.malformed(src, mark2, 1);
            }
            return Decoder.xflow(src, mark2, 0);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }

        private static ByteBuffer getByteBuffer(ByteBuffer bb, byte[] ba, int sp2) {
            if (bb == null) {
                bb = ByteBuffer.wrap(ba);
            }
            bb.position(sp2);
            return bb;
        }

        public int decode(byte[] sa, int sp2, int len, char[] da) {
            int sl = sp2 + len;
            int dp = 0;
            int dlASCII = Math.min(len, da.length);
            ByteBuffer bb = null;
            while (dp < dlASCII && sa[sp2] >= 0) {
                da[dp++] = (char)sa[sp2++];
            }
            while (sp2 < sl) {
                byte b3;
                byte b2;
                byte b1;
                if ((b1 = sa[sp2++]) >= 0) {
                    da[dp++] = (char)b1;
                    continue;
                }
                if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                    if (sp2 < sl) {
                        if (Decoder.isNotContinuation(b2 = sa[sp2++])) {
                            if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                                return -1;
                            }
                            da[dp++] = this.replacement().charAt(0);
                            --sp2;
                            continue;
                        }
                        da[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                        continue;
                    }
                    if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                        return -1;
                    }
                    da[dp++] = this.replacement().charAt(0);
                    return dp;
                }
                if (b1 >> 4 == -2) {
                    if (sp2 + 1 < sl) {
                        if (Decoder.isMalformed3(b1, b2 = sa[sp2++], b3 = sa[sp2++])) {
                            if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                                return -1;
                            }
                            da[dp++] = this.replacement().charAt(0);
                            bb = Decoder.getByteBuffer(bb, sa, sp2 -= 3);
                            sp2 += Decoder.malformedN(bb, 3).length();
                            continue;
                        }
                        char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                        if (StrictUtf8.isSurrogate(c)) {
                            if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                                return -1;
                            }
                            da[dp++] = this.replacement().charAt(0);
                            continue;
                        }
                        da[dp++] = c;
                        continue;
                    }
                    if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                        return -1;
                    }
                    if (sp2 < sl && Decoder.isMalformed3_2(b1, sa[sp2])) {
                        da[dp++] = this.replacement().charAt(0);
                        continue;
                    }
                    da[dp++] = this.replacement().charAt(0);
                    return dp;
                }
                if (b1 >> 3 == -2) {
                    if (sp2 + 2 < sl) {
                        b2 = sa[sp2++];
                        b3 = sa[sp2++];
                        byte b4 = sa[sp2++];
                        int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                        if (Decoder.isMalformed4(b2, b3, b4) || !Character.isSupplementaryCodePoint(uc)) {
                            if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                                return -1;
                            }
                            da[dp++] = this.replacement().charAt(0);
                            bb = Decoder.getByteBuffer(bb, sa, sp2 -= 4);
                            sp2 += Decoder.malformedN(bb, 4).length();
                            continue;
                        }
                        da[dp++] = StrictUtf8.highSurrogate(uc);
                        da[dp++] = StrictUtf8.lowSurrogate(uc);
                        continue;
                    }
                    if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                        return -1;
                    }
                    if (sp2 < sl && Decoder.isMalformed4_2(b1, sa[sp2])) {
                        da[dp++] = this.replacement().charAt(0);
                        continue;
                    }
                    if (++sp2 < sl && Decoder.isMalformed4_3(sa[sp2])) {
                        da[dp++] = this.replacement().charAt(0);
                        continue;
                    }
                    da[dp++] = this.replacement().charAt(0);
                    return dp;
                }
                if (this.malformedInputAction() != CodingErrorAction.REPLACE) {
                    return -1;
                }
                da[dp++] = this.replacement().charAt(0);
            }
            return dp;
        }
    }
}

